<?php
namespace SabaiApps\Directories\Component\Search\WordPressBlock;

use SabaiApps\Directories\Component\WordPress\Block\AbstractBlock;
use SabaiApps\Directories\Exception\RuntimeException;

class SearchWordPressBlock extends AbstractBlock
{
    protected function _wordpressBlockInfo()
    {
        return [
            'json' => true,
            'package' => 'directories',
            'icon' => 'search',
        ];
    }

    public function wordpressBlockEditorVars()
    {
        $bundles = [];
        foreach ($this->_application->Entity_Bundles(null, 'Directory') as $bundle) {
            if (!empty($bundle->info['search_enable'])) {
                $bundles[] = ['value' => $bundle->name, 'label' => $bundle->getGroupLabel() . ' - ' . $bundle->getLabel()];
            }
        }

        return [
            'bundles' => $bundles,
            'button_colors' => $this->_toSelectControlOptions($this->_getButtonColors()),
            'sizes' => $this->_toSelectControlOptions($this->_getSizes()),
            'responsives' => $this->_toSelectControlOptions($this->_getResponsives()),
        ];
    }

    protected function _getButtonColors()
    {
        return [
            'primary' => 'Primary',
            'secondary' => 'Secondary',
            'success' => 'Success',
            'warning' => 'Warning',
            'danger' => 'Danger',
            'info' => 'Info',
            'dark' => 'Dark',
            'light' => 'Light',
        ];
    }

    protected function _getSizes()
    {
        return [
            '' => __('Normal', 'directories'),
            'lg' => __('Large', 'directories'),
        ];
    }

    protected function _getResponsives()
    {
        return [
            1 => __('Responsive', 'directories'),
            -1 => __('Display inline', 'directories'),
            0 => __('Stacked', 'directories'),
        ];
    }

    public function wordpressBlockRender(array $attributes, $content, $isEditor)
    {
        if (empty($attributes['bundle'])
            || (!$bundle = $this->_application->Entity_Bundle($attributes['bundle']))
            || empty($bundle->info['search_enable'])
        ) {
            throw new RuntimeException('Invalid bundle specified: ' . $attributes['bundle']);
        }
        $extra_params = [];
        if (isset($attributes['btnText'])) {
            if ('' === $extra_params['btn_text'] = trim($attributes['btnText'])) {
                $extra_params['btn_icon'] = 'fas fa-search';
            }
        } else {
            $extra_params['btn_text'] = '';
            $extra_params['btn_icon'] = 'fas fa-search';
        }
        if (!empty($attributes['btnColor'])) {
            $btn_colors = $this->_getButtonColors();
            if (isset($btn_colors[$attributes['btnColor']])) {
                $extra_params['btn_color'] = $attributes['btnColor'];
            }
        }
        if (isset($attributes['size'])
            && ('' !== $size = trim($attributes['size']))
        ){
            $sizes = $this->_getSizes();
            if (isset($sizes[$size])) {
                $extra_params['size'] = $size;
            }
        }
        if (isset($attributes['responsive'])
            && is_numeric($attributes['responsive'])
        ){
            $responsive = intval($attributes['responsive']);
            $responsive_options = $this->_getResponsives();
            if (isset($responsive_options[$responsive])) {
                $extra_params['responsive'] = $responsive;
            }
        }
        if (isset($attributes['style'])
            && ('' !== $style = trim($attributes['style']))
        ){
            $extra_params['style'] = $style;
        }
        $shortcode = sprintf(
            '[drts-directory-search directory="%s" type="%s"%s]',
            $bundle->group,
            $bundle->type,
            $this->_application->Attr($extra_params)
        );

        return do_shortcode($shortcode);
    }
}